import codeanticode.syphon.*;
import oscP5.*;
import netP5.*;
 
PGraphics canvas;
SyphonServer server;
OscP5 oscP5;
NetAddress videoMapperAddress;
NetAddress trackerMasterAddress;

ArrayList<Ball> balls; // an array of ball objects NB: they also need to draw to the canvas!
int ballWidth = 48;

int canvasW = 5120; // the actual size of the texture to display
int canvasH = 720; // the actual size of the texture to display

void setup(){
  frameRate(60);
  size(1280,180,P3D); // sets the miniature size to save processing power
  
  canvas = createGraphics(canvasW,canvasH,P3D); // create the canvas to render to and used to transmt via syphon
  
  // set up a new sypon (i.e. texture) server
  server = new SyphonServer(this, "Processing_Syphon");
  
  // set up a new OSC network interface
  oscP5 = new OscP5(this,12000);
  
  // register for video mapping
  videoMapperAddress = new NetAddress("127.0.0.1",8400);
  OscMessage videoMapperMessage = new OscMessage("/SwitchSyphonClient");
  videoMapperMessage.add("Canvas_Drawing_to_Syphon"); // This must contain the same name as the Sketch
  videoMapperMessage.add("Processing_Syphon");
  videoMapperMessage.add(1.0); // the transparency of the the texture in the mapper, leave at 1.0
  oscP5.send(videoMapperMessage, videoMapperAddress);  // send this message to the mapper to display your image
  
  // register for tracking
  trackerMasterAddress = new NetAddress("127.0.0.1",64000);
  OscMessage trackerMasterMessage = new OscMessage("/trackerMaster/requestTuiostream");
  trackerMasterMessage.add(12000); // the port you wish to receive touch information on
  oscP5.send(trackerMasterMessage, trackerMasterAddress);  // subscribe to tuio-stream
 
  // your draing stuff
  // Create an empty ArrayList (will store Ball objects)
  balls = new ArrayList<Ball>();
  // Start by adding one element
  balls.add(new Ball(width/2, 0, ballWidth)); 
}

void mousePressed() {
  // A new ball object is added to the ArrayList (by default to the end)
  balls.add(new Ball(floor(map(mouseX,0,width,0,canvasW)), mouseY, ballWidth));  
}
 
void draw(){
  if(mousePressed){
      balls.add(new Ball(floor(map(mouseX,0,width,0,canvasW)), mouseY, ballWidth));
  }
  
  canvas.beginDraw(); // all the drawing has to happen in the canvas in order to share across syphon
  canvas.noStroke();
  canvas.background(255, 255, 255);
  // With an array, we say balls.length, with an ArrayList, we say balls.size()
  // The length of an ArrayList is dynamic
  // Notice how we are looping through the ArrayList backwards
  // This is because we are deleting elements from the list  
  for (int i = balls.size()-1; i >= 0; i--) { 
    // An ArrayList doesn't know what it is storing so we have to cast the object coming out
    Ball ball = balls.get(i);
    ball.move();
    ball.display();
    if (ball.finished()) {
      // Items can be deleted with remove()
      balls.remove(i);
    } 
  }
  canvas.endDraw();
  server.sendImage(canvas); // now send the image across syphon to the mapping software
  image(canvas,0,0, width, height); // and draw your local small version
  println(frameRate);
}





