import codeanticode.syphon.*;
import oscP5.*;
import netP5.*;
 
PGraphics canvas;
SyphonServer server;
OscP5 oscP5;
NetAddress videoMapperAddress;
NetAddress trackerMasterAddress;


ArrayList<Ball> balls;
int ballWidth = 48;


int canvasW = 5120;
int canvasH = 720;

void setup(){
  size(1280,180,P3D);
  
   canvas = createGraphics(canvasW,canvasH,P3D);
  //smooth(8);
  frameRate(60);
  
   

  // Create an empty ArrayList (will store Ball objects)
  balls = new ArrayList<Ball>();
  
  // Start by adding one element
  balls.add(new Ball(width/2, 0, ballWidth));
  
  
  
  
 
  


 server = new SyphonServer(this, "Processing_Syphon");

 oscP5 = new OscP5(this,12000);
  
  
  // register for video mapping
  videoMapperAddress = new NetAddress("127.0.0.1",8400);
  
  OscMessage videoMapperMessage = new OscMessage("/SwitchSyphonClient");
  
  videoMapperMessage.add("Ted_Canvas_Solution"); //It must contain the same name as the Sketch
  videoMapperMessage.add("Processing_Syphon");
  videoMapperMessage.add(1.0);
  oscP5.send(videoMapperMessage, videoMapperAddress); 
  
  // register for tracking
  trackerMasterAddress = new NetAddress("127.0.0.1",64000);
  
  OscMessage trackerMasterMessage = new OscMessage("/trackerMaster/requestTuiostream");
  
  trackerMasterMessage.add(12000);
  oscP5.send(trackerMasterMessage, trackerMasterAddress); 
  
}



  
  

void mousePressed() {
  // A new ball object is added to the ArrayList (by default to the end)
//  balls.add(new Ball(floor(map(mouseX,0,width,0,canvasW)), mouseY, ballWidth));
  
}
 
void draw(){
  
  if(mousePressed){
      balls.add(new Ball(floor(map(mouseX,0,width,0,canvasW)), mouseY, ballWidth));
  }
  
  canvas.beginDraw();
  canvas.noStroke();
  canvas.background(255);

  // With an array, we say balls.length, with an ArrayList, we say balls.size()
  // The length of an ArrayList is dynamic
  // Notice how we are looping through the ArrayList backwards
  // This is because we are deleting elements from the list  
  for (int i = balls.size()-1; i >= 0; i--) { 
    // An ArrayList doesn't know what it is storing so we have to cast the object coming out
    Ball ball = balls.get(i);
    ball.move();
    ball.display();
    if (ball.finished()) {
      // Items can be deleted with remove()
      balls.remove(i);
    }
    
  }  
  
  
  
  canvas.endDraw();
   
   server.sendImage(canvas);
  
  image(canvas,0,0, width, height);
  println(frameRate);
}





