import codeanticode.syphon.*;
import oscP5.*;
import netP5.*;
 
PGraphics canvas;
SyphonServer server;
OscP5 oscP5;
NetAddress videoMapperAddress;
NetAddress trackerMasterAddress;






void setup(){
  size(512,720,P3D);
  canvas = createGraphics(5120,720,P3D);
  //smooth(8);
  frameRate(60);
  


 server = new SyphonServer(this, "Processing_Syphon");
 oscP5 = new OscP5(this,12000);
  
  
  // register for video mapping
  videoMapperAddress = new NetAddress("127.0.0.1",8400);
  
  OscMessage videoMapperMessage = new OscMessage("/SwitchSyphonClient");
  
  videoMapperMessage.add("Video_Mapper_Connection");   //It must contain the same name as the Sketch
  videoMapperMessage.add("Processing_Syphon");
  videoMapperMessage.add(1.0);
  oscP5.send(videoMapperMessage, videoMapperAddress); 
  
  // register for tracking
  trackerMasterAddress = new NetAddress("127.0.0.1",64000);
  
  OscMessage trackerMasterMessage = new OscMessage("/trackerMaster/requestTuiostream");
  
  trackerMasterMessage.add(12000);
  oscP5.send(trackerMasterMessage, trackerMasterAddress); 
  
}



  
  


 
void draw(){
  
  canvas.beginDraw();
  canvas.background(0);
  
  canvas.rect (400, 100, 600, 100);
  canvas.endDraw();
   
   server.sendImage(canvas);
  
  image(canvas,0,0);
  println(frameRate);
}





