ServerOptions.devices;

// start
~recall.value(0);


(
{
	~sectionReceiver.remove;
	thisProcess.removeOSCRecvFunc(f);
	~parameterUpdateRoutine.stop;
	s.freeAll;

	/*------------------------------------------------------------------
	audio interface
	-------------------------------------------------------------------*/

	o = Server.local.options;
	//o.device = nil;
	//o.device = "Fireface 800 (AA)";
	//o.device = "Generic USB Audio Device";
	o.device = "Soundflower (64ch)";

	//o.memSize = 2.pow(14);
	//o.hardwareBufferSize = 1024;

	s.bootSync;

	v = s.volume = -6;
	v.mute;

	/*------------------------------------------------------------------
	global settings
	-------------------------------------------------------------------*/

	~parameterUpdateRate = 0.05;
	~loSynthAmp = 0.25;

	/*------------------------------------------------------------------
	osc receiver
	-------------------------------------------------------------------*/

	~synths = List.new; // an array to hold all synths
	~values = Dictionary.new;

	f = { |msg, time, replyAddr, recvPort| // receive all incoming traffic
		var swarmName, startIndex, parameter, agent, data, synth, vel;
		if(msg[0].asString.contains("/swarm")) // exclude other messages
		{
			swarmName = msg[0].asString.split.[1];
			startIndex = msg[0].asString.split.[2].asInteger;
			parameter = msg[0].asString.split.[3];
			msg.removeAt(0);

			data = msg.clump(3);

			if(~values.at(swarmName) == nil, { ~values.put(swarmName,List.new) });

			data.do{ |vector, i|
				i = i + startIndex;
				if(i >= ~values.at(swarmName).size, { ~values.at(swarmName).add(Array.fill(7,nil)) });

				if(parameter == "position", {
					~values.at(swarmName)[i] = [vector[0],
						vector[1], vector[2],
						~values.at(swarmName)[i][3],
						~values.at(swarmName)[i][0],
						~values.at(swarmName)[i][1],
						~values.at(swarmName)[i][2]]});

				if(parameter == "velocity", {
					vel = ((vector[0]**2)+(vector[1]**2)+(vector[2]**2))**0.5;
					~values.at(swarmName)[i].put(3, vel)});
			};
		}
	};

	thisProcess.addOSCRecvFunc(f);

	/*------------------------------------------------------------------
	dispatcher functions
	-------------------------------------------------------------------*/

	~defaultDispatcher = { |synth,agent|
		var x,y,z,x1,y1,z1,xx,yy,zz,vel;

		if(~values.at("swarm") != nil and: {~values.at("swarm2") != nil}, {

			x  = ~values.at("swarm")[agent][0];
			x1 = ~values.at("swarm")[agent][4];
			y  = ~values.at("swarm")[agent][1];
			y1 = ~values.at("swarm")[agent][5];
			z  = ~values.at("swarm")[agent][2];
			z1 = ~values.at("swarm")[agent][6];

			vel = ~values.at("swarm")[agent][3];

			xx = ~values.at("swarm2")[1][0];
			yy = ~values.at("swarm2")[1][1];
			zz = ~values.at("swarm2")[1][2];

			synth.set(\x,x,\y,y,\z,z,\vel,vel);
			synth.set(\xx,xx,\yy,yy,\zz,zz);

			if(x != nil and: {x1 != nil} and: {abs(x1-x) > 2.0}, { synth.set(\t_trig,1,\t_xtrig,1) });
			if(y != nil and: {y1 != nil} and: {abs(y1-y) > 2.0}, { synth.set(\t_trig,1,\t_ytrig,1) });
			if(z != nil and: {z1 != nil} and: {abs(z1-z) > 2.0}, { synth.set(\t_trig,1,\t_ztrig,1) });

			if(y != nil and: {y1 != nil} and: {abs(y1-y) > 0.1}, { synth.set(\t_yjump,1) });
			if(y != nil and: {y >= -0.6} and: {y <= 0.6},        { synth.set(\mid,0.5); }, { synth.set(\mid,0); });
		});
	};


	~parameterUpdateRoutine =
	fork {
		loop {
			~synths.do{ |item| if(item.at(\synth).isRunning,
				{ ~defaultDispatcher.value(item.at(\synth),item.at(\agent)) } )
			};
			~parameterUpdateRate.wait;
		}
	};


	/*------------------------------------------------------------------
	synths
	-------------------------------------------------------------------*/

	"Trails2_synths_panels.scd".loadRelative;
	s.sync;



	"Trails2_synth_bindings_panels.scd".loadRelative; // identical with Trails2_bindings.scd



	/*------------------------------------------------------------------
	conductor
	-------------------------------------------------------------------*/

	"Trails2_conductor_panels.scd".loadRelative;


	/*------------------------------------------------------------------
	sections
	-------------------------------------------------------------------*/

	~sectionReceiver = OSCresponder(nil, '/section', {
		|time, addr, msg|

		// hiSynth
		if([1,2].find([msg[1]]) != nil,
			{~hiSynths.do { |item| item.set(\gate, 1); item.run };},
			{~hiSynths.do { |item| item.set(\gate, 0) }; });

		if([1].find([msg[1]]) != nil,
			{~hiSynths.do { |item| item.set(\dur, 0.1, \suslevel, 0.01, \panWidth, 5) };},
			{~hiSynths.do { |item| item.set(\dur, 0.2, \suslevel, 0.1) }; });

		// hiNoise
		if([1].find([msg[1]]) != nil,
			{~hiNoises.do { |item| item.set(\gate, 1); item.run };},
			{~hiNoises.do { |item| item.set(\gate, 0) }; });

		// hiTextureSynth
		if([3].find([msg[1]]) != nil,
			{~hiTextureSynths.do { |item| item.set(\gate, 1); item.run }; },
			{~hiTextureSynths.do { |item| item.set(\gate, 0) }; });

		// bell
		if([2,3].find([msg[1]]) != nil,
			{~bells.do { |item| item.set(\gate, 1); item.run }; },
			{~bells.do { |item| item.set(\gate, 0) }; });

		// loSynth
		if([2,3,10,12].find([msg[1]]) != nil,
			{~loSynths.do { |item| item.set(\gate, 1); item.run }; },
			{~loSynths.do { |item| item.set(\gate, 0) }; });

		// loSynthPulse
		if([0,11].find([msg[1]]) != nil,
			{~loPulseSynths.do { |item| item.set(\gate, 1); item.run }; },
			{~loPulseSynths.do { |item| item.set(\gate, 0) }; });

		// poly1Synth
		if([8,9].find([msg[1]]) != nil,
			{~poly1Synths.do { |item| item.set(\gate, 1); item.run }; },
			{~poly1Synths.do { |item| item.set(\gate, 0) }; });

		if([8].find([msg[1]]) != nil,
			{~poly1Synths.do { |item| item.set(\basefrq, 150, \lag, 0.0001) }; },
			{~poly1Synths.do { |item| item.set(\basefrq, 1000, \lag, 0.001) }; });

		// poly2Synth
		if([4,5].find([msg[1]]) != nil,
			{~poly2Synths.do { |item| item.set(\gate, 1); item.run }; },
			{~poly2Synths.do { |item| item.set(\gate, 0) }; });

		if([4].find([msg[1]]) != nil,
			{~poly2Synths.do { |item| item.set(\delta,10,\rate,0) }; },
			{~poly2Synths.do { |item| item.set(\delta,30,\rate,250) }; });

		// poly3Synth
		if([10,11,12].find([msg[1]]) != nil,
			{~poly3Synths.do { |item| item.set(\gate, 1); item.run }; },
			{~poly3Synths.do { |item| item.set(\gate, 0) }; });

		if([10,12].find([msg[1]]) != nil,
			{~poly3Synths.do { |item| item.set(\suslevel,0.01) }; },
			{~poly3Synths.do { |item| item.set(\suslevel,0.3) }; });

		if([11].find([msg[1]]) != nil,
			{~poly3Synths.do { |item| item.set(\panWidth,12) }; },
			{~poly3Synths.do { |item| item.set(\panWidth,4) }; });

		// distortion
		if([4,5].find([msg[1]]) != nil,
			{~distortion.do { |item| item.set(\vol, 1) }; },
			{~distortion.do { |item| item.set(\vol, 0) }; });

		// noise2
		if([4,5].find([msg[1]]) != nil,
			{~noise2.do { |item| item.set(\vol, 1) }; },
			{~noise2.do { |item| item.set(\vol, 0) }; });

		// delay1Synth
		if([6,12,0].find([msg[1]]) != nil,
			{~delay1Synths.do { |item| item.set(\gate, 1, \del, 0.0001); item.run}; },
			{~delay1Synths.do { |item| item.set(\gate, 0) }; });

		if([0,12].find([msg[1]]) != nil,
			{~delay1Synths.do { |item| item.set(\panWidth, 4); }; },
			{~delay1Synths.do { |item| item.set(\panWidth, 3) }; });


		// delay2Synth
		if([7,8].find([msg[1]]) != nil,
			{~delay2Synths.do { |item| item.set(\gate, 1); item.run }; },
			{~delay2Synths.do { |item| item.set(\gate, 0) }; });

		if([8].find([msg[1]]) != nil,
			{~delay2Synths.do { |item| item.set(\th, 0.95, \panWidth, 4) }; },
			{~delay2Synths.do { |item| item.set(\th, 0.25, \panWidth, 6) }; });



		// tuio interaction
		case
		{msg[1] == 0}  { ~tuioXscale = 50.0; ~tuioYscale =  9.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 1}  { ~tuioXscale = 70.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 2}  { ~tuioXscale = 90.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 1; }
		{msg[1] == 3}  { ~tuioXscale = 90.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 1; }
		{msg[1] == 4}  { ~tuioXscale = 70.0; ~tuioYscale = 12.0; ~tuioZoffset = 5.0; ~interactiveMode = 0; }
		{msg[1] == 5}  { ~tuioXscale = 70.0; ~tuioYscale = 12.0; ~tuioZoffset = 5.0; ~interactiveMode = 0; }
		{msg[1] == 6}  { ~tuioXscale = 80.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 7}  { ~tuioXscale = 10.0; ~tuioYscale =  5.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 8}  { ~tuioXscale = 60.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 9}  { ~tuioXscale = 60.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 10} { ~tuioXscale = 30.0; ~tuioYscale = 10.0; ~tuioZoffset = 0.0; ~interactiveMode = 0; }
		{msg[1] == 11} { ~tuioXscale = 20.0; ~tuioYscale = 10.0; ~tuioZoffset = 5.0; ~interactiveMode = 0; };



		// start
		if(msg[1] == 0, {
			v.unmute;
		});


}).add;

}.fork
)

// start
~recall.value(0);

~singleSection = nil;

v.unmute
s.volume = -9

// recording
s.prepareForRecord;
s.record;
s.stopRecording;


// stop receiving
~sectionReceiver.remove;
thisProcess.removeOSCRecvFunc(f);
~parameterUpdateRoutine.stop;