import codeanticode.syphon.*;
 
PGraphics canvas;
SyphonServer server;

float[] x_pos = new float[200];
float[] y_pos = new float[200];
float[] factor_x = new float[200]; 
float[] factor_y = new float[200]; 
float[] size_x = new float[200];
float[] size_y = new float[200];
float[] halfsize_x = new float[200];
float[] halfsize_y = new float[200];

int numBars, drawBars;

void setup(){
  size(5120,720,P3D);
  canvas = createGraphics(5120,720,P3D);
  smooth(8);
  frameRate(200);

  server = new SyphonServer(this, "Processing Syphon");

  numBars = 200;
  // init values for running bars  
  for(int i = 0; i < numBars; i++){
    factor_x[i] = random(0.1, 10.0);
    factor_y[i] = random(0.1, 2.0);
    size_x[i] = random(width/3) + 1;
    size_y[i] = random(height/5) + 1;
    halfsize_x[i] = size_x[i] * 0.5;
    halfsize_y[i] = size_y[i] * 0.5;
  }
}
 
void draw(){
  clear();
  calc();
   
  canvas.beginDraw();
  canvas.background(32,0,32,127);
  canvas.noFill();
  canvas.stroke(255, 255, 255, 100);
  
  for(int i = 0; i < numBars; i++){
      canvas.strokeWeight( size_y[i]/4 );
      canvas.rect(x_pos[i]-halfsize_x[i], y_pos[i]-halfsize_y[i], size_x[i], size_y[i], 20);
  }
  canvas.endDraw();
  server.sendImage(canvas);
  
  //image(canvas,0,0);
  println(frameRate);
}

void calc(){
  for(int i = 0; i < numBars; i++){
    if( (i % 2) == 0){
      x_pos[i] += 1 * factor_x[i];
      y_pos[i] += 1 * factor_y[i];
      
    }else{
      x_pos[i] -= 1 * factor_x[i];
      y_pos[i] -= 1 * factor_y[i];   
      x_pos[i] = width + x_pos[i];    
      y_pos[i] = height + y_pos[i];    
    }
    x_pos[i] = x_pos[i] % width;
    y_pos[i] = y_pos[i] % height;
  }
}
